// Appointment Form AJAX Submission
document.addEventListener('DOMContentLoaded', function() {
    var appointmentForm = document.getElementById('appointmentForm');
    
    if (appointmentForm) {
        appointmentForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            var form = this;
            var formData = new FormData(form);
            var messageDiv = document.getElementById('form-messages');
            
            // Disable submit button
            var submitBtn = form.querySelector('button[type="submit"]');
            var originalText = submitBtn.textContent;
            submitBtn.disabled = true;
            submitBtn.textContent = 'Sending...';
            
            fetch('appointment.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                messageDiv.innerHTML = '<div class="alert alert-success">' + data + '</div>';
                form.reset();
                
                // Auto-hide success message after 5 seconds
                setTimeout(function() {
                    messageDiv.innerHTML = '';
                }, 5000);
            })
            .catch(error => {
                messageDiv.innerHTML = '<div class="alert alert-danger">An error occurred. Please try again.</div>';
            })
            .finally(() => {
                submitBtn.disabled = false;
                submitBtn.textContent = originalText;
            });
        });
    }
});